<?php
// ENVIO DE NOTIFICAÇÕES WEB PUSH

$vapid = require __DIR__ . '/vapid_keys.php';

require __DIR__ . '/vendor/web-push-php-master/src/WebPush.php';
require __DIR__ . '/vendor/web-push-php-master/src/Subscription.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

$auth = [
    'VAPID' => [
        'subject' => 'mailto:contato@jpweb.com.br',
        'publicKey' => $vapid['publicKey'],
        'privateKey' => $vapid['privateKey'],
    ],
];

try {
    $pdo = new PDO('mysql:host=localhost;dbname=seu_banco','usuario','senha',[
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("❌ Erro ao conectar ao banco: " . $e->getMessage());
}

$stmt = $pdo->query("SELECT token AS subscription FROM notificacoes_token");
$subscriptions = $stmt->fetchAll();
if (empty($subscriptions)) die("⚠️ Nenhum token encontrado");

$payload = json_encode([
    'title' => $_POST['title'] ?? 'Nova Notificação',
    'body'  => $_POST['body']  ?? 'Toque para abrir',
    'url'   => $_POST['url']   ?? '/',
]);

$webPush = new WebPush($auth);

foreach ($subscriptions as $row) {
    $subData = json_decode($row['subscription'], true);
    if (!$subData) continue;

    $subscription = Subscription::create($subData);

    try {
        $report = $webPush->sendOneNotification($subscription, $payload);
        echo $report->isSuccess()
            ? "✅ Notificação enviada para {$subData['endpoint']}<br>"
            : "❌ Falha ao enviar: " . $report->getReason() . "<br>";
    } catch (Exception $e) {
        echo "⚠️ Erro: " . $e->getMessage() . "<br>";
    }
}

echo json_encode(['status'=>'success','message'=>'Envio concluído']);
