<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_Cloudchannel_GoogleCloudChannelV1TransferEntitlementsRequest extends Google_Collection
{
  protected $collection_key = 'entitlements';
  public $authToken;
  protected $entitlementsType = 'Google_Service_Cloudchannel_GoogleCloudChannelV1Entitlement';
  protected $entitlementsDataType = 'array';
  public $requestId;

  public function setAuthToken($authToken)
  {
    $this->authToken = $authToken;
  }
  public function getAuthToken()
  {
    return $this->authToken;
  }
  /**
   * @param Google_Service_Cloudchannel_GoogleCloudChannelV1Entitlement[]
   */
  public function setEntitlements($entitlements)
  {
    $this->entitlements = $entitlements;
  }
  /**
   * @return Google_Service_Cloudchannel_GoogleCloudChannelV1Entitlement[]
   */
  public function getEntitlements()
  {
    return $this->entitlements;
  }
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  public function getRequestId()
  {
    return $this->requestId;
  }
}
